/*
 * Decompiled with CFR 0.152.
 */
package org.munin;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Configuration {
    private Properties graph_properties = new Properties();
    private Map<String, FieldProperties> fieldMap = new HashMap<String, FieldProperties>();
    private List<FieldProperties> fields = new ArrayList<FieldProperties>();

    private Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration parse(String config_file) throws IOException, MalformedObjectNameException, NullPointerException {
        BufferedReader reader = new BufferedReader(new FileReader(config_file));
        Configuration configuration = new Configuration();
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                if (s.startsWith("%") || s.length() <= 5 || s.startsWith(" ")) continue;
                configuration.parseString(s);
            }
        }
        finally {
            reader.close();
        }
        return configuration;
    }

    private void parseString(String s) throws MalformedObjectNameException, NullPointerException {
        String[] nameval = s.split(" ", 2);
        if (nameval[0].indexOf(46) > 0) {
            FieldProperties field;
            String name = nameval[0];
            String fieldname = name.substring(0, name.lastIndexOf(46));
            if (!this.fieldMap.containsKey(fieldname)) {
                field = new FieldProperties(fieldname);
                this.fieldMap.put(fieldname, field);
                this.fields.add(field);
            }
            field = this.fieldMap.get(fieldname);
            String key = name.substring(name.lastIndexOf(46) + 1);
            field.set(key, nameval[1]);
        } else {
            this.graph_properties.put(nameval[0], nameval[1]);
        }
    }

    public Properties getGraphProperties() {
        return this.graph_properties;
    }

    public void report(PrintStream out) {
        for (Map.Entry<Object, Object> entry : this.graph_properties.entrySet()) {
            out.println(entry.getKey() + " " + entry.getValue());
        }
        for (FieldProperties field : this.fields) {
            field.report(out);
        }
    }

    public List<FieldProperties> getFields() {
        return this.fields;
    }

    public class FieldProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private ObjectName jmxObjectName;
        private String jmxAttributeName;
        private String jmxAttributeKey;
        private String fieldname;
        private static final String JMXOBJECT = "jmxObjectName";
        private static final String JMXATTRIBUTE = "jmxAttributeName";
        private static final String JMXATTRIBUTEKEY = "jmxAttributeKey";

        public FieldProperties(String fieldname) {
            this.fieldname = fieldname;
        }

        public String getJmxAttributeKey() {
            return this.jmxAttributeKey;
        }

        public String getJmxAttributeName() {
            return this.jmxAttributeName;
        }

        public ObjectName getJmxObjectName() {
            return this.jmxObjectName;
        }

        @Override
        public String toString() {
            return this.fieldname;
        }

        public void set(String key, String value) throws MalformedObjectNameException, NullPointerException {
            if (JMXOBJECT.equals(key)) {
                if (this.jmxObjectName != null) {
                    throw new IllegalStateException("jmxObjectName already set for " + this);
                }
                this.jmxObjectName = new ObjectName(value);
            } else if (JMXATTRIBUTE.equals(key)) {
                if (this.jmxAttributeName != null) {
                    throw new IllegalStateException("jmxAttributeName already set for " + this);
                }
                this.jmxAttributeName = value;
            } else if (JMXATTRIBUTEKEY.equals(key)) {
                if (this.jmxAttributeKey != null) {
                    throw new IllegalStateException("jmxAttributeKey already set for " + this);
                }
                this.jmxAttributeKey = value;
            } else {
                this.put(key, value);
            }
        }

        public void report(PrintStream out) {
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                out.println(this.fieldname + '.' + entry.getKey() + " " + entry.getValue());
            }
        }

        public String getFieldname() {
            return this.fieldname;
        }
    }
}

